/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.tiviacz.pizzacraft.blockentity.BaseBlockEntity;
import com.tiviacz.pizzacraft.init.ModAdvancements;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.items.KnifeItem;
import com.tiviacz.pizzacraft.recipes.chopping.ChoppingRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ChoppingBoardBlockEntity
extends BaseBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private boolean isItemCarvingBoard = false;
    private Direction facing = Direction.NORTH;
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private final String IS_ITEM_CARVING_BOARD = "IsItemCarvingBoard";
    private final String FACING = "Facing";

    public ChoppingBoardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CHOPPING_BOARD.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.facing = Direction.m_122407_((int)compound.m_128451_("Facing"));
        this.isItemCarvingBoard = compound.m_128471_("IsItemCarvingBoard");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("Facing", this.facing.m_122416_());
        compound.m_128379_("IsItemCarvingBoard", this.isItemCarvingBoard);
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction direction) {
        this.facing = direction;
    }

    public boolean canChop(ItemStack stack) {
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)ChoppingRecipe.Type.CHOPPING_BOARD_RECIPE_TYPE, (Container)new RecipeWrapper(this.getInventory()), this.f_58857_);
        boolean matchTool = stack.m_41720_() instanceof KnifeItem || stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof TridentItem || stack.m_41720_() instanceof ShearsItem;
        return matchTool && match.isPresent();
    }

    public void chop(ItemStack stack, @Nullable Player player) {
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)ChoppingRecipe.Type.CHOPPING_BOARD_RECIPE_TYPE, (Container)new RecipeWrapper(this.getInventory()), this.f_58857_);
        if (match.isPresent()) {
            ItemStack result = ((ChoppingRecipe)match.get()).m_8043_().m_41777_();
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getStoredStack()), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.3, (double)this.m_58899_().m_123343_() + 0.5, 0.0, 0.0, 0.0);
            this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12296_, SoundSource.BLOCKS, 0.7f, 0.8f);
            Direction direction = this.facing.m_122428_();
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2, (double)this.m_58899_().m_123342_() + 0.2, (double)this.m_58899_().m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2, result.m_41777_());
            entity.m_20334_((double)((float)direction.m_122429_() * 0.2f), 0.0, (double)((float)direction.m_122431_() * 0.2f));
            this.f_58857_.m_7967_((Entity)entity);
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(InteractionHand.MAIN_HAND));
            } else if (stack.m_220157_(1, this.f_58857_.f_46441_, null)) {
                stack.m_41764_(0);
            }
            if (player instanceof ServerPlayer) {
                ModAdvancements.CHOPPING_BOARD.trigger((ServerPlayer)player);
            }
            this.getStoredStack().m_41774_(1);
            this.m_6596_();
        }
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            this.inventory.insertItem(0, tool, false);
            return true;
        }
        return false;
    }

    public boolean addItem(ItemStack stack) {
        if (this.isEmpty() && !stack.m_41619_()) {
            this.isItemCarvingBoard = false;
            this.m_6596_();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredStack();
            this.m_6596_();
            return item;
        }
        return ItemStack.f_41583_;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                ChoppingBoardBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

